%%%-------This Code Calculate the Entropy of an Image I
%%%------Inputs:
%%%          I: image
%%%          L: number of histogram bins
%%%------OutPut:
%%%          h: Entropy of image I.
%%%          p: mariginal probability

%%%Written By Walid Abdelmoula (LUMC)

function h = ImageEntropy(I,L)

% [counts, x] = imhist(I, L); %If you have a gray scale image
[counts, x] = hist(I, L);

for i=1:length(counts)
    p = counts(i)/sum(counts); %%%probability of each intensity value in image I
    if (p>0)
        v(i) = p * log2(p);
    else
        v(i) = 0;
    end
end

h = - (sum(v));  %%Entropy of the image I.
